// pciinfo.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "resource.h"
HINSTANCE hinstDLLl;
lppatt_proc Main_Proc;

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    hinstDLLl=(HINSTANCE)hModule;
	return TRUE;
}


void APIENTRY get_plug_info(PPlugInfo Data) {
	strcpy(Data->Menu_Text,"PCI Info");
	Data->PluginType=PL_STD;
	Data->Sign=ATT_Sign;
}

void CreateColumns(HWND list) {
LV_COLUMN lvC;
lvC.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
lvC.fmt = LVCFMT_LEFT;
lvC.cx = 75;
lvC.pszText = "Bus";
int index=0;
ListView_InsertColumn(list,index,&lvC);
lvC.pszText = "Device";index++;
ListView_InsertColumn(list,index,&lvC);
lvC.pszText = "Function";index++;
ListView_InsertColumn(list,index,&lvC);
lvC.pszText = "Vendor";index++;
ListView_InsertColumn(list,index,&lvC);
lvC.pszText = "Device ID";index++;
ListView_InsertColumn(list,index,&lvC);
lvC.cx = 220;
lvC.pszText = "Description";index++;
ListView_InsertColumn(list,index,&lvC);


}
BOOL CALLBACK MyDialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	char bus=0;
	char dev=0;
	char fun=0;
	int index=0;
	TPCIIO pt;
	DWORD res,data1,db1;
	bool flag=true;
	char text[255];
	HWND hwndList = GetDlgItem(hwndDlg, IDC_LIST2); 
	LV_ITEM lvI;
	lvI.mask = LVIF_TEXT | LVIF_STATE;
	lvI.state = 0;
	lvI.stateMask = 0;
	
	lvI.iSubItem = 0;

	switch (uMsg) {
	    case WM_INITDIALOG:
			//Collect PCI Devices
			SendMessage(hwndList,LVM_SETEXTENDEDLISTVIEWSTYLE,0,LVS_EX_FULLROWSELECT );

			CreateColumns(hwndList);
			while 	(flag) {
				pt.bus=bus;
				pt.device=dev;
				pt.func=fun;
				pt.offset=0;
				Main_Proc(atc_getPCIBusDataW,&pt,&res);
				//res=res & 0x0000FFFF;
				if ((res!=0xFFFF) && (res!=0)){
					pt.offset=2;
					Main_Proc(atc_getPCIBusDataW,&pt,&data1);
					lvI.iItem = index;
					sprintf(text,"%02X",bus);// Dev#%d Fun#%d %4x:%4x",bus,dev,fun,res,&data1);
					lvI.pszText = text;
					ListView_InsertItem(hwndList, &lvI);
					sprintf(text,"%02X",dev);
					ListView_SetItemText(hwndList,index,1,text);
					sprintf(text,"%02X",fun);
					ListView_SetItemText(hwndList,index,2,text);
					sprintf(text,"%04X",res);
					ListView_SetItemText(hwndList,index,3,text);
					sprintf(text,"%04X",data1);
					ListView_SetItemText(hwndList,index,4,text);
					
					pt.offset=0xA; //device code and sub code
					Main_Proc(atc_getPCIBusDataW,&pt,&db1);		 

					switch (db1) {
						case 0x0101:strcpy(text,"IDE Controller");break;
						case 0x0104:strcpy(text,"RAID Controller");break;
						case 0x0100:strcpy(text,"SCSI Controller");break;
						case 0x0102:strcpy(text,"FD Controller");break;
						case 0x0103:strcpy(text,"IPI Controller");break;
						case 0x0180:strcpy(text,"Other storage controller");break;
						case 0x0200:strcpy(text,"Ethernet controller");break;
						case 0x0201:strcpy(text,"TL Controller");break;
						case 0x0202:strcpy(text,"DDI Controller");break;
						case 0x0203:strcpy(text,"ATM Controller");break;
						case 0x0280:strcpy(text,"DDI Controller");break;
						case 0x0300:strcpy(text,"VGA Adapter");break;
						case 0x0380:strcpy(text,"Other VGA Adapter");break;
						case 0x0400:strcpy(text,"Video controller");break;
						case 0x0401:strcpy(text,"Sound Controller");break;
						case 0x0480:strcpy(text,"Other Multimedia");break;
						case 0x0500:strcpy(text,"Ram");break;
						case 0x0580:strcpy(text,"Other memory");break;
						case 0x0600:strcpy(text,"Host Bridge Device");break;
						case 0x0601:strcpy(text,"ISA Bridge");break;
						case 0x0602:strcpy(text,"EISA Bridge");break;
						case 0x0603:strcpy(text,"Micro channel bridge");break;
						case 0x0604:strcpy(text,"PCI to PCI Bridge");break;
						case 0x0605:strcpy(text,"PCMCIA bridge");break;
						case 0x0606:strcpy(text,"NuBus bridge");break;
						case 0x0607:strcpy(text,"CardBus bridge");break;
						case 0x0680:strcpy(text,"Other bridge");break;
						case 0x0700:strcpy(text,"XT compatible");break;
						case 0x0701:strcpy(text,"Parallel");break;
						case 0x0980:strcpy(text,"Input Device");break;
						case 0x0C05:strcpy(text,"i2c/SMBus Serial Bus Controller");break;
						case 0x0C03:strcpy(text,"USB Controller");break;
						default:
						sprintf(text,"Unknown %4x",db1);
					}
					
					ListView_SetItemText(hwndList,index,5,text);
					index++;
				}
				fun++;
				if (fun<8) continue;

				dev++;
				fun=0;
				if (dev<31) continue;

				bus++;
				if (bus==8) break;
				fun=0;
				dev=0;
				
			}
			SetFocus(hwndList); 
			return TRUE;
			break;
		case WM_CLOSE: 
			EndDialog(hwndDlg,0);
			break;
		case WM_COMMAND: 
			switch (LOWORD(wParam)) 
			{ 
				case IDOK: 
					EndDialog(hwndDlg,0);
                break; 
        } 
	}
	return FALSE;
}


void APIENTRY exec_plugin (HWND Win_Handle, lppatt_proc ATT_Proc) {
	//creating dialog box window
	Main_Proc=ATT_Proc;
	DialogBox(hinstDLLl,MAKEINTRESOURCE(IDD_DIALOG1),Win_Handle,MyDialogProc);

}

